# generated from rosidl_generator_py/resource/_idl.py.em
# with input from novatel_gps_msgs:msg/NovatelDualAntennaHeading.idl
# generated code does not contain a copyright notice


# Import statements for member types

import builtins  # noqa: E402, I100

import math  # noqa: E402, I100

import rosidl_parser.definition  # noqa: E402, I100


class Metaclass_NovatelDualAntennaHeading(type):
    """Metaclass of message 'NovatelDualAntennaHeading'."""

    _CREATE_ROS_MESSAGE = None
    _CONVERT_FROM_PY = None
    _CONVERT_TO_PY = None
    _DESTROY_ROS_MESSAGE = None
    _TYPE_SUPPORT = None

    __constants = {
        'SOURCE_PRIMARY_ANTENNA': 0,
        'SOURCE_SECONDARY_ANTENNA': 1,
    }

    @classmethod
    def __import_type_support__(cls):
        try:
            from rosidl_generator_py import import_type_support
            module = import_type_support('novatel_gps_msgs')
        except ImportError:
            import logging
            import traceback
            logger = logging.getLogger(
                'novatel_gps_msgs.msg.NovatelDualAntennaHeading')
            logger.debug(
                'Failed to import needed modules for type support:\n' +
                traceback.format_exc())
        else:
            cls._CREATE_ROS_MESSAGE = module.create_ros_message_msg__msg__novatel_dual_antenna_heading
            cls._CONVERT_FROM_PY = module.convert_from_py_msg__msg__novatel_dual_antenna_heading
            cls._CONVERT_TO_PY = module.convert_to_py_msg__msg__novatel_dual_antenna_heading
            cls._TYPE_SUPPORT = module.type_support_msg__msg__novatel_dual_antenna_heading
            cls._DESTROY_ROS_MESSAGE = module.destroy_ros_message_msg__msg__novatel_dual_antenna_heading

            from novatel_gps_msgs.msg import NovatelExtendedSolutionStatus
            if NovatelExtendedSolutionStatus.__class__._TYPE_SUPPORT is None:
                NovatelExtendedSolutionStatus.__class__.__import_type_support__()

            from novatel_gps_msgs.msg import NovatelMessageHeader
            if NovatelMessageHeader.__class__._TYPE_SUPPORT is None:
                NovatelMessageHeader.__class__.__import_type_support__()

            from novatel_gps_msgs.msg import NovatelSignalMask
            if NovatelSignalMask.__class__._TYPE_SUPPORT is None:
                NovatelSignalMask.__class__.__import_type_support__()

            from std_msgs.msg import Header
            if Header.__class__._TYPE_SUPPORT is None:
                Header.__class__.__import_type_support__()

    @classmethod
    def __prepare__(cls, name, bases, **kwargs):
        # list constant names here so that they appear in the help text of
        # the message class under "Data and other attributes defined here:"
        # as well as populate each message instance
        return {
            'SOURCE_PRIMARY_ANTENNA': cls.__constants['SOURCE_PRIMARY_ANTENNA'],
            'SOURCE_SECONDARY_ANTENNA': cls.__constants['SOURCE_SECONDARY_ANTENNA'],
        }

    @property
    def SOURCE_PRIMARY_ANTENNA(self):
        """Message constant 'SOURCE_PRIMARY_ANTENNA'."""
        return Metaclass_NovatelDualAntennaHeading.__constants['SOURCE_PRIMARY_ANTENNA']

    @property
    def SOURCE_SECONDARY_ANTENNA(self):
        """Message constant 'SOURCE_SECONDARY_ANTENNA'."""
        return Metaclass_NovatelDualAntennaHeading.__constants['SOURCE_SECONDARY_ANTENNA']


class NovatelDualAntennaHeading(metaclass=Metaclass_NovatelDualAntennaHeading):
    """
    Message class 'NovatelDualAntennaHeading'.

    Constants:
      SOURCE_PRIMARY_ANTENNA
      SOURCE_SECONDARY_ANTENNA
    """

    __slots__ = [
        '_header',
        '_novatel_msg_header',
        '_solution_status',
        '_position_type',
        '_baseline_length',
        '_heading',
        '_pitch',
        '_heading_sigma',
        '_pitch_sigma',
        '_station_id',
        '_num_satellites_tracked',
        '_num_satellites_used_in_solution',
        '_num_satellites_above_elevation_mask_angle',
        '_num_satellites_above_elevation_mask_angle_l2',
        '_solution_source',
        '_extended_solution_status',
        '_signal_mask',
    ]

    _fields_and_field_types = {
        'header': 'std_msgs/Header',
        'novatel_msg_header': 'novatel_gps_msgs/NovatelMessageHeader',
        'solution_status': 'string',
        'position_type': 'string',
        'baseline_length': 'float',
        'heading': 'float',
        'pitch': 'float',
        'heading_sigma': 'float',
        'pitch_sigma': 'float',
        'station_id': 'string',
        'num_satellites_tracked': 'uint8',
        'num_satellites_used_in_solution': 'uint8',
        'num_satellites_above_elevation_mask_angle': 'uint8',
        'num_satellites_above_elevation_mask_angle_l2': 'uint8',
        'solution_source': 'uint8',
        'extended_solution_status': 'novatel_gps_msgs/NovatelExtendedSolutionStatus',
        'signal_mask': 'novatel_gps_msgs/NovatelSignalMask',
    }

    SLOT_TYPES = (
        rosidl_parser.definition.NamespacedType(['std_msgs', 'msg'], 'Header'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['novatel_gps_msgs', 'msg'], 'NovatelMessageHeader'),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.BasicType('float'),  # noqa: E501
        rosidl_parser.definition.UnboundedString(),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.BasicType('uint8'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['novatel_gps_msgs', 'msg'], 'NovatelExtendedSolutionStatus'),  # noqa: E501
        rosidl_parser.definition.NamespacedType(['novatel_gps_msgs', 'msg'], 'NovatelSignalMask'),  # noqa: E501
    )

    def __init__(self, **kwargs):
        assert all('_' + key in self.__slots__ for key in kwargs.keys()), \
            'Invalid arguments passed to constructor: %s' % \
            ', '.join(sorted(k for k in kwargs.keys() if '_' + k not in self.__slots__))
        from std_msgs.msg import Header
        self.header = kwargs.get('header', Header())
        from novatel_gps_msgs.msg import NovatelMessageHeader
        self.novatel_msg_header = kwargs.get('novatel_msg_header', NovatelMessageHeader())
        self.solution_status = kwargs.get('solution_status', str())
        self.position_type = kwargs.get('position_type', str())
        self.baseline_length = kwargs.get('baseline_length', float())
        self.heading = kwargs.get('heading', float())
        self.pitch = kwargs.get('pitch', float())
        self.heading_sigma = kwargs.get('heading_sigma', float())
        self.pitch_sigma = kwargs.get('pitch_sigma', float())
        self.station_id = kwargs.get('station_id', str())
        self.num_satellites_tracked = kwargs.get('num_satellites_tracked', int())
        self.num_satellites_used_in_solution = kwargs.get('num_satellites_used_in_solution', int())
        self.num_satellites_above_elevation_mask_angle = kwargs.get('num_satellites_above_elevation_mask_angle', int())
        self.num_satellites_above_elevation_mask_angle_l2 = kwargs.get('num_satellites_above_elevation_mask_angle_l2', int())
        self.solution_source = kwargs.get('solution_source', int())
        from novatel_gps_msgs.msg import NovatelExtendedSolutionStatus
        self.extended_solution_status = kwargs.get('extended_solution_status', NovatelExtendedSolutionStatus())
        from novatel_gps_msgs.msg import NovatelSignalMask
        self.signal_mask = kwargs.get('signal_mask', NovatelSignalMask())

    def __repr__(self):
        typename = self.__class__.__module__.split('.')
        typename.pop()
        typename.append(self.__class__.__name__)
        args = []
        for s, t in zip(self.__slots__, self.SLOT_TYPES):
            field = getattr(self, s)
            fieldstr = repr(field)
            # We use Python array type for fields that can be directly stored
            # in them, and "normal" sequences for everything else.  If it is
            # a type that we store in an array, strip off the 'array' portion.
            if (
                isinstance(t, rosidl_parser.definition.AbstractSequence) and
                isinstance(t.value_type, rosidl_parser.definition.BasicType) and
                t.value_type.typename in ['float', 'double', 'int8', 'uint8', 'int16', 'uint16', 'int32', 'uint32', 'int64', 'uint64']
            ):
                if len(field) == 0:
                    fieldstr = '[]'
                else:
                    assert fieldstr.startswith('array(')
                    prefix = "array('X', "
                    suffix = ')'
                    fieldstr = fieldstr[len(prefix):-len(suffix)]
            args.append(s[1:] + '=' + fieldstr)
        return '%s(%s)' % ('.'.join(typename), ', '.join(args))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        if self.header != other.header:
            return False
        if self.novatel_msg_header != other.novatel_msg_header:
            return False
        if self.solution_status != other.solution_status:
            return False
        if self.position_type != other.position_type:
            return False
        if self.baseline_length != other.baseline_length:
            return False
        if self.heading != other.heading:
            return False
        if self.pitch != other.pitch:
            return False
        if self.heading_sigma != other.heading_sigma:
            return False
        if self.pitch_sigma != other.pitch_sigma:
            return False
        if self.station_id != other.station_id:
            return False
        if self.num_satellites_tracked != other.num_satellites_tracked:
            return False
        if self.num_satellites_used_in_solution != other.num_satellites_used_in_solution:
            return False
        if self.num_satellites_above_elevation_mask_angle != other.num_satellites_above_elevation_mask_angle:
            return False
        if self.num_satellites_above_elevation_mask_angle_l2 != other.num_satellites_above_elevation_mask_angle_l2:
            return False
        if self.solution_source != other.solution_source:
            return False
        if self.extended_solution_status != other.extended_solution_status:
            return False
        if self.signal_mask != other.signal_mask:
            return False
        return True

    @classmethod
    def get_fields_and_field_types(cls):
        from copy import copy
        return copy(cls._fields_and_field_types)

    @builtins.property
    def header(self):
        """Message field 'header'."""
        return self._header

    @header.setter
    def header(self, value):
        if __debug__:
            from std_msgs.msg import Header
            assert \
                isinstance(value, Header), \
                "The 'header' field must be a sub message of type 'Header'"
        self._header = value

    @builtins.property
    def novatel_msg_header(self):
        """Message field 'novatel_msg_header'."""
        return self._novatel_msg_header

    @novatel_msg_header.setter
    def novatel_msg_header(self, value):
        if __debug__:
            from novatel_gps_msgs.msg import NovatelMessageHeader
            assert \
                isinstance(value, NovatelMessageHeader), \
                "The 'novatel_msg_header' field must be a sub message of type 'NovatelMessageHeader'"
        self._novatel_msg_header = value

    @builtins.property
    def solution_status(self):
        """Message field 'solution_status'."""
        return self._solution_status

    @solution_status.setter
    def solution_status(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'solution_status' field must be of type 'str'"
        self._solution_status = value

    @builtins.property
    def position_type(self):
        """Message field 'position_type'."""
        return self._position_type

    @position_type.setter
    def position_type(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'position_type' field must be of type 'str'"
        self._position_type = value

    @builtins.property
    def baseline_length(self):
        """Message field 'baseline_length'."""
        return self._baseline_length

    @baseline_length.setter
    def baseline_length(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'baseline_length' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'baseline_length' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._baseline_length = value

    @builtins.property
    def heading(self):
        """Message field 'heading'."""
        return self._heading

    @heading.setter
    def heading(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'heading' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'heading' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._heading = value

    @builtins.property
    def pitch(self):
        """Message field 'pitch'."""
        return self._pitch

    @pitch.setter
    def pitch(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'pitch' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'pitch' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._pitch = value

    @builtins.property
    def heading_sigma(self):
        """Message field 'heading_sigma'."""
        return self._heading_sigma

    @heading_sigma.setter
    def heading_sigma(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'heading_sigma' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'heading_sigma' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._heading_sigma = value

    @builtins.property
    def pitch_sigma(self):
        """Message field 'pitch_sigma'."""
        return self._pitch_sigma

    @pitch_sigma.setter
    def pitch_sigma(self, value):
        if __debug__:
            assert \
                isinstance(value, float), \
                "The 'pitch_sigma' field must be of type 'float'"
            assert not (value < -3.402823466e+38 or value > 3.402823466e+38) or math.isinf(value), \
                "The 'pitch_sigma' field must be a float in [-3.402823466e+38, 3.402823466e+38]"
        self._pitch_sigma = value

    @builtins.property
    def station_id(self):
        """Message field 'station_id'."""
        return self._station_id

    @station_id.setter
    def station_id(self, value):
        if __debug__:
            assert \
                isinstance(value, str), \
                "The 'station_id' field must be of type 'str'"
        self._station_id = value

    @builtins.property
    def num_satellites_tracked(self):
        """Message field 'num_satellites_tracked'."""
        return self._num_satellites_tracked

    @num_satellites_tracked.setter
    def num_satellites_tracked(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_satellites_tracked' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_satellites_tracked' field must be an unsigned integer in [0, 255]"
        self._num_satellites_tracked = value

    @builtins.property
    def num_satellites_used_in_solution(self):
        """Message field 'num_satellites_used_in_solution'."""
        return self._num_satellites_used_in_solution

    @num_satellites_used_in_solution.setter
    def num_satellites_used_in_solution(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_satellites_used_in_solution' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_satellites_used_in_solution' field must be an unsigned integer in [0, 255]"
        self._num_satellites_used_in_solution = value

    @builtins.property
    def num_satellites_above_elevation_mask_angle(self):
        """Message field 'num_satellites_above_elevation_mask_angle'."""
        return self._num_satellites_above_elevation_mask_angle

    @num_satellites_above_elevation_mask_angle.setter
    def num_satellites_above_elevation_mask_angle(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_satellites_above_elevation_mask_angle' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_satellites_above_elevation_mask_angle' field must be an unsigned integer in [0, 255]"
        self._num_satellites_above_elevation_mask_angle = value

    @builtins.property
    def num_satellites_above_elevation_mask_angle_l2(self):
        """Message field 'num_satellites_above_elevation_mask_angle_l2'."""
        return self._num_satellites_above_elevation_mask_angle_l2

    @num_satellites_above_elevation_mask_angle_l2.setter
    def num_satellites_above_elevation_mask_angle_l2(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'num_satellites_above_elevation_mask_angle_l2' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'num_satellites_above_elevation_mask_angle_l2' field must be an unsigned integer in [0, 255]"
        self._num_satellites_above_elevation_mask_angle_l2 = value

    @builtins.property
    def solution_source(self):
        """Message field 'solution_source'."""
        return self._solution_source

    @solution_source.setter
    def solution_source(self, value):
        if __debug__:
            assert \
                isinstance(value, int), \
                "The 'solution_source' field must be of type 'int'"
            assert value >= 0 and value < 256, \
                "The 'solution_source' field must be an unsigned integer in [0, 255]"
        self._solution_source = value

    @builtins.property
    def extended_solution_status(self):
        """Message field 'extended_solution_status'."""
        return self._extended_solution_status

    @extended_solution_status.setter
    def extended_solution_status(self, value):
        if __debug__:
            from novatel_gps_msgs.msg import NovatelExtendedSolutionStatus
            assert \
                isinstance(value, NovatelExtendedSolutionStatus), \
                "The 'extended_solution_status' field must be a sub message of type 'NovatelExtendedSolutionStatus'"
        self._extended_solution_status = value

    @builtins.property
    def signal_mask(self):
        """Message field 'signal_mask'."""
        return self._signal_mask

    @signal_mask.setter
    def signal_mask(self, value):
        if __debug__:
            from novatel_gps_msgs.msg import NovatelSignalMask
            assert \
                isinstance(value, NovatelSignalMask), \
                "The 'signal_mask' field must be a sub message of type 'NovatelSignalMask'"
        self._signal_mask = value
